/*  Source Code for Micron MT35XU Low Level Driver */


/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER. 
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/

#ifndef __INC_H_SLL_EMLX_DRVRH
#define __INC_H_SLL_EMLX_DRVRH


#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

#include "sll_ca_xspi_mc_t004_reg.h"

/*Define Version */
#define SLL_EMLX_DRVR_VERSION  "22.2.3"   //  Year.Quarter.Minor


/**
*   Macros to create data storage for driver instance
*/

#define SLL_EMLX_FLASH_INSTANCE(dev)                                  \
static sll_xspi_flash_dev dev =                                       \
{                                                                     \
  {                                                                   \
    .status_rd_cmd                 = 0x0505,                          \
    .flag_status_rd_cmd            = 0x7070,                          \
    .id_rd_cmd                     = 0x9F9F,                          \
    .sfpd_rd_cmd                   = 0x5A5A,                          \
    .any_reg_rd_cmd                = 0x8585,                          \
    .any_nvreg_rd_cmd              = 0xB5B5,                          \
    .reset_cmd                     = 0x9999,                          \
    .reset_en_cmd                  = 0x6666,                          \
    .wren_cmd                      = 0x0606,                          \
    .sector_4k_erase_cmd           = 0x2020,                          \
    .sector_erase_cmd              = 0xD8D8,                          \
    .bulk_erase_cmd                = 0xC7C7,                          \
    .bulk_wr_cmd                   = 0x8282,                          \
    .nop_cmd                       = 0x0000,                          \
    .any_reg_wr_cmd                = 0x8181,                          \
    .any_nvreg_wr_cmd              = 0xB1B1,                          \
                                                                      \
    .flash_dev_ready               = 0x00,                            \
    .flash_dev_ready_mask          = 0x01,                            \
                                                                      \
    .flash_dev_flag_ready          = 0x80,                            \
    .flash_dev_flag_ready_mask     = 0x80,                            \
    .flash_dev_flag_erase_susp_mask= 0x40,                            \
    .flash_dev_flag_erase_mask     = 0x20,                            \
    .flash_dev_flag_program_mask   = 0x10,                            \
    .flash_dev_flag_sec_lock_mask  = 0x02,                            \
                                                                      \
    .xspi_mbmc_status_rd_cmd      = SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY7, \
    .xspi_mbmc_reg_rd_cmd         = SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY7, \
    .xspi_mbmc_sfpd_rd_cmd        = SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY7, \
                                                                      \
    .use_flg_status_register      = 1,                                \
    .use_flg2_status_register     = 0,                                \
   },                                     \
   .name                          = "EMLX", \
   .sector_size                   = (16*1024), \
   .page_size                     = 256  \
} ;





#endif /* __INC_H_SLL_EMLX_DRVRH  */


